//==========================================================================
// File Name   : ISR.asm
// Description : Interrupt Service Routine
// Written by  : Ray Cheng
// Last modified date:
//              2005/12/26
// Note: 
// 1. Interrupts must be declared in TEXT area.
// 2. For FIQ, IRQ1 ~ IRQ7, user needs to clear P_INT_Clear before 
//    exiting interrupt routine
// 3. 
// 	_FIQ:	FIQ								// Fast interrupt entry
//  _IRQ0:	TimerA							// interrupt entry
//  _IRQ1:	TimerB							// interrupt entry
//  _IRQ2:	TimerC							// interrupt entry
//  _IRQ3:	UART, SPI, SIO					// interrupt entry
//  _IRQ4:	SPU								// interrupt entry
//  _IRQ5:	KEY, EXT1, EXT2					// interrupt entry
//  _IRQ6:	512Hz, 2KHz, 4KHz				// interrupt entry     
//  _IRQ7:	2Hz, 16Hz, 64Hz					// interrupt entry
//  _Break: Software interrupt              // interrupt entry
//==========================================================================
//**************************************************************************
// Header File Included Area
//**************************************************************************
.include GPCE2P064.inc
.include A1800.inc
.include ComAir5_RX.inc
.include ComAir5_IOTX.inc

//**************************************************************************
// Contant Defintion Area
//**************************************************************************

//**************************************************************************
// Variable Publication Area
//**************************************************************************

//**************************************************************************
// Function Call Publication Area
//**************************************************************************
.public _BREAK
.public _FIQ
.public _IRQ0
.public _IRQ1
.public _IRQ2
.public _IRQ3
.public _IRQ4
.public _IRQ5
.public _IRQ6
.public _IRQ7

//**************************************************************************
// External Variable Declaration
//**************************************************************************

//**************************************************************************
// External Function Declaration
//**************************************************************************

//**************************************************************************
// RAM Definition Area
//**************************************************************************

//**************************************************************************
// CODE Definition Area
//**************************************************************************
.text
_FIQ:// RX:48KHz
    push R1, R5 to [SP];
    
	CALL	F_ISR_Service_ComAir5_RX; 			
    R1 = C_IRQ0_TMA;
	[P_INT_Status] = R1;

	pop R1, R5 from [SP];
	reti;

//****************************************************************
_BREAK:        
    push R1, R5 to [SP];

	pop R1, R5 from [SP];
	reti; 
        
_IRQ0:        
    push R1, R5 to [SP];
	
	CALL	F_ISR_Service_SACM_A1800;		
	R1 = C_IRQ0_TMA;
	[P_INT_Status] = R1;

	pop R1, R5 from [SP];
	reti; 
        
_IRQ1: 
    push R1, R5 to [SP];


	pop R1, R5 from [SP];
	reti;  
        
_IRQ2:        
    push R1, R5 to [SP];

	pop R1, R5 from [SP];
	reti;         
        
_IRQ3:        
    push R1, R5 to [SP];

	pop R1, R5 from [SP];
	reti;         
        
_IRQ4:        
    push R1, R5 to [SP];

	pop R1, R5 from [SP];
	reti;  
        
_IRQ5:        
    push R1, R5 to [SP];

	pop R1, R5 from [SP];
	reti;         
        
_IRQ6:        
    push R1, R5 to [SP];

	CALL	F_ISR_Service_ComAir5_IOTX;

    R1 = C_IRQ6_4096Hz;
	[P_INT_Status] = R1;
	pop R1, R5 from [SP];
	reti;         
        
_IRQ7:        
    push R1, R5 to [SP];

	pop R1, R5 from [SP];
	reti;
